var default_boyan_header_number = 6;
var default_page_index = '2000';
var table_header_names = ['Index', 'Parameter Name', 'Value', 'Data Type', 'Default Value', 'Access Type', 'Comment']

var t0;
var t1;
var eds_object;
t0 = performance.now();

$(function() 
{
	$(document).on('click', '.index_number', function()
	{ 
        $('.index_number').removeClass("selected")
        $(this).addClass("selected");
    });

    $(document).on('click', '.accordion-header', function()
	{ 
        localStorage.setItem("selected_accordion_header", $(this).index());
    });

    $(document).on('mouseover', '.index_number', function()
	{ 
        $(this).addClass("hover");
    });

	$(document).on('mouseout', '.index_number', function()
	{       
        $(this).removeClass("hover");
    });
});

$(document).ready(function() 
{
	get_set_value.set_eds_object();
	get_set_value.set_expert_page_configuration();
	//get saved data
	var selected_page_index = localStorage.getItem("selected_page_index");
	if (selected_page_index == null)
	{
		var selected_page_index = default_page_index;
	}
	var selected_boyan_header = localStorage.getItem("selected_accordion_header");
	if (selected_boyan_header == null)
	{
		var boyan_header_number = default_boyan_header_number;
	}
	else
	{
		var boyan_header_number = Number(selected_boyan_header)/2;
	}

	main_page(selected_page_index);
	select_page(selected_page_index);

	$("#boyan").accordion({ heightStyle: 'content', header: '.accordion-header', active: boyan_header_number});
	$("#boyan").accordion( "option", "collapsible", true );
	$(".index_number").button();
	//send_query();
	
	//$(".datetime").datepicker();
	//t1 = performance.now();
	//console.log('Took', (t1 - t0).toFixed(4));
	console.log(`Last commit datetime: ${commit_date.commit_date}`);
});

function main_page(selected_page_index)
{	
	var autoupdate_input = '<label><label class="autoupdate"><span></span></label> Autoupdate</label>'
	$("#main").append(autoupdate_input);
	
	var boyan = $('<div id="boyan">');
	$.each(configuration.expert_page_dictionary(), function(index, group_param)
	{
		var group_indexes = eds_object[group_param.name];
		if ((group_indexes != ''))//(group_param.name == group_name) && 
		{
			var boyan_header = $('<div>').addClass('accordion-header');
			var boyan_body = $('<div>').addClass('accordion-body');

			boyan_header.html('(' + group_param.minIndex + ' - ' + group_param.maxIndex + ')</br>' + group_param.name);

			$.each(group_indexes, function(index, item)
			{
				var index_div = $('<div>').addClass('index_number');
				var index_str = '#index' + item.index;
				index_div.text('0x' + item.index + ' ' + item.ParameterName);
				index_div.attr({'id':index_str, 'onclick':"select_page('" + item.index + "');"});		
				
				if (item.index == selected_page_index)
				{
					index_div.addClass('selected');
				}
				boyan_body.append(index_div);
			});
			
			boyan.append(boyan_header);
			boyan.append(boyan_body);
		}
	});
	$("#main").append(boyan);
}

function select_page(index_number)
{
	var table = $('<table>');
	var	table_name = $('<h4>').addClass('table_name');
	var table_header = $('<tr>').addClass('table_header');

	localStorage.setItem("selected_page_index", index_number);
	$("#second_html").html(''); //clear frame
	
	$.each(eds_object,function(group_name, group_indexes)
	{
		$.each(group_indexes, function(eds_item_index, eds_item_data)
		{
			if (eds_item_data.index == index_number)
			{
				var name_comment = '';
				if (eds_item_data.Comment != null)
				{
					name_comment = '(' + eds_item_data.Comment + ')';
				}
				
				table_name.html('<b>0x' + eds_item_data.index + '</b> - ' + eds_item_data.ParameterName + ' ' + name_comment); 

				if (eds_item_data.Subs != null)
			    {
					get_set_value.set_request_data(eds_item_data.Subs);
					//get_set_value.set_expert_page_configuration();
					get_set_value.send_query();

			    	$.each(table_header_names, function (table_header_index, table_header_name) 
					{
						if (table_header_name == "Index")
						{
							table_header_name = "Subindex"
						}
						var column_name = $('<td>').text(table_header_name);
					    table_header.append(column_name);
					});
					table.append(table_header);

			    	$.each(eds_item_data.Subs, function(sub_item_index, sub_item_data)
					{	
						if (sub_item_data.index != null)
						{
							var table_row = $('<tr>');
							var index_parts = sub_item_data.index.split(":");
							var index_str = index_parts[1];
							table_row.append($('<td>').text(index_str));
							table_row.append($('<td>').text(sub_item_data.ParameterName));
							table_row.append($('<td>').append(get_set_value.get_cell(sub_item_index)));
							table_row.append($('<td>').text(sub_item_data.DataType));
							table_row.append($('<td>').text(sub_item_data.DefaultValue));
							table_row.append($('<td>').text(sub_item_data.AccessType));
							table_row.append($('<td>').text(sub_item_data.Comment));
							table.append(table_row);
						}
			    	});
			    }
			}
		});
	});

	$("#second_html").append(table_name);
	$("#second_html").append(table);
}



